/**
 * Ensures that Adam IDs are always represented with the same format
 *
 * "ID" segments in a URL typically include an `id` prefix that should
 * not be present when using the value as an identifier for a resource
 * in the Media APi.
 *
 * This function strips the prefix if present
 */
export function normalizeAdamID(raw) {
    if (raw.startsWith("id")) {
        return raw.substring(2);
    }
    return raw;
}
//# sourceMappingURL=util.js.map