/**
 * Created by km on 2/13/17.
 */
import * as actions from "../actions";
import * as base from "../base";
import * as metrics from "../metrics/metrics";
/** @public */
export class BaseSearchPage extends base.Model {
    constructor() {
        super();
        this.pageMetrics = new metrics.PageMetrics();
        this.pageRenderMetrics = {};
    }
}
/** @public */
export class SearchResults extends BaseSearchPage {
}
/**
 * @public
 * Message to show user when search results need additional context.
 * Currently supported by:
 * - iOS, for NLS Safety UI
 */
export class SearchResultsContextCard extends base.ViewModel {
    constructor(message, action) {
        super();
        this.message = message;
        this.action = action;
    }
}
/** @public */
export class SearchResultsPage extends BaseSearchPage {
    constructor(shelfModels = []) {
        super();
        /// The shelves of the results page.
        this.shelves = [];
        this.shelves = shelfModels;
    }
}
export class SegmentedSearchResultsPage {
    constructor() {
        this.selectedSegmentId = null;
        this.segments = [];
    }
}
export var SegmentedSearchResultsPageSegmentType;
(function (SegmentedSearchResultsPageSegmentType) {
    SegmentedSearchResultsPageSegmentType["visionOS"] = "xros";
    SegmentedSearchResultsPageSegmentType["iOS"] = "ios";
})(SegmentedSearchResultsPageSegmentType || (SegmentedSearchResultsPageSegmentType = {}));
export class SegmentedSearchResultsPageSegment {
}
/** @public */
export class SearchFacetSet extends base.Model {
    constructor(type, values) {
        super();
        this.type = type;
        this.values = values;
    }
}
/** @public */
export class SearchFacetValue extends base.Model {
    constructor(name, value, selectedValue = null) {
        super();
        this.name = name;
        this.value = value;
        this.isSelected = value === selectedValue;
    }
}
/** @public */
export class SearchAdOpportunity extends base.Model {
    constructor(instanceId, searchLifecycleEventPayloads, searchAd) {
        super();
        this.instanceId = instanceId;
        this.eventPayloads = searchLifecycleEventPayloads;
        this.searchAd = searchAd;
    }
    /**
     * Sets the template type on the event payloads for metrics tracking
     * @param templateType The native ad template type
     */
    setTemplateType(templateType) {
        this.eventPayloads.placed.iAdTemplateType = templateType;
    }
    /**
     * Sets the duplicate position on the event payloads for metrics tracking. This is only expected for search results
     * @param position The position of the duplicate organic app lockup that appeared in the shelf's contents
     */
    setDuplicatePosition(position) {
        this.eventPayloads.placed.duplicatePosition = position;
    }
    /**
     * Sets the missed reason code on the event payloads for metrics tracking
     * @param reasonCode The reason that the opportunity was not filled
     */
    setMissedOpportunityReason(reasonCode) {
        this.eventPayloads.placed.missedOpportunityReason = reasonCode;
    }
}
/** @public */
export class SearchAd extends base.Model {
    constructor(instanceId, iAdObject, searchAdLifecycleEventPayloads, impressionId, transparencyAction) {
        super();
        this.instanceId = instanceId;
        this.iAd = iAdObject;
        this.eventPayloads = searchAdLifecycleEventPayloads;
        this.impressionId = impressionId;
        this.transparencyAction = transparencyAction;
    }
    /**
     * Sets the template type on the event payloads for metrics tracking
     * @param templateType The native ad template type
     */
    setTemplateType(templateType) {
        this.eventPayloads.placed.iAdTemplateType = templateType;
    }
    /**
     * Sets the duplicate position on the event payloads for metrics tracking. This is only expected for search results
     * @param position The position of the duplicate organic app lockup that appeared in the shelf's contents
     */
    setDuplicatePosition(position) {
        this.eventPayloads.placed.duplicatePosition = position;
    }
}
/** @public */
export class AdTransparencyAction extends actions.Action {
    constructor(adTransparencyData) {
        super("AdTransparencyAction");
        this.adTransparencyData = adTransparencyData;
    }
}
/** @public */
export class SearchAction extends actions.Action {
    constructor(title, term, url, origin, entity, source, presentationStyle, referrerData) {
        super("SearchAction");
        /**
         * Whether or not Search should opt-in to spell-checking, which will:
         * - Correct high-confidence misspellings server-side.
         * - Suggest queries for low-confidence misspellings
         *
         * This defaults to `false`. Currently `true` for user-typed term and hints terms.
         */
        this.spellCheckEnabled = false;
        this.title = title;
        this.term = term;
        this.url = url;
        this.origin = origin;
        this.entity = entity;
        this.source = source;
        this.presentationStyle = presentationStyle !== null && presentationStyle !== void 0 ? presentationStyle : ["textFollowsTintColor"];
        this.referrerData = referrerData;
    }
}
// endregion
// region Search Hints
/** @public */
export class SearchHintSet extends base.Model {
    constructor(hints, ghostHintTerm) {
        super();
        this.hints = hints;
        this.ghostHintTerm = ghostHintTerm;
        this.pageMetrics = new metrics.PageMetrics();
        this.pageRenderMetrics = {};
    }
}
// endregion
// region Trending Searches
/** @public */
export class TrendingSearches extends base.Model {
    constructor(title, searches) {
        super();
        this.title = title;
        this.searches = searches;
    }
}
// endregion
// region Search Message
/**
 * @public
 * Message associated with a set of Search Results.
 * Currently supported by:
 * - iOS, for Spell Correction feature.
 */
export class SearchResultsMessage extends base.Model {
    constructor(primaryText, secondaryText, messageClickAction = null) {
        super();
        this.primaryText = primaryText;
        this.secondaryText = secondaryText;
        this.messageClickAction = messageClickAction;
    }
}
/** @public */
export class SearchResult extends base.ViewModel {
    constructor(resultType) {
        super();
        this.resultType = resultType;
        this.clickAction = null;
    }
}
/**
 * @public
 * Search result for a single app
 */
export class AppSearchResult extends SearchResult {
    constructor(lockup) {
        super("content");
        this.lockup = lockup;
    }
}
/** @public */
export class InAppPurchaseSearchResult extends SearchResult {
    constructor(lockup) {
        super("inAppPurchase");
        this.lockup = lockup;
    }
}
/** @public */
export class BundleSearchResult extends SearchResult {
    constructor(lockup) {
        super("bundle");
        this.lockup = lockup;
    }
}
/** @public */
export class AdvertsSearchResult extends SearchResult {
    constructor() {
        super("advert");
        this.lockups = [];
        this.displaysScreenshots = true;
        this.itemBackground = "ad";
    }
}
/** @public */
export class AppEventSearchResult extends SearchResult {
    constructor() {
        super("appEvent");
    }
}
/** @public */
export class EditorialSearchResult extends SearchResult {
    constructor(title) {
        super("editorial");
        this.title = title;
    }
}
/**
 * @public
 * Collection of lockups with shared heading and title.
 * May include an action to show additional details (e.g. FlowAction to Article)
 */
export class SearchLockupCollection extends SearchResult {
    constructor(heading, title, items, detailAction, headingArtwork) {
        super("lockupCollection");
        this.heading = heading;
        this.headingArtwork = headingArtwork;
        this.title = title;
        this.items = items;
        this.detailAction = detailAction;
    }
}
/**
 * @public
 * Guided search suggestions shown mid-scroll alongside other search results.
 */
export class GuidedSearchResult extends SearchResult {
    constructor(title, tokens) {
        super("guidedSearch");
        this.title = title;
        this.tokens = tokens;
    }
}
/**
 * @public
 * A model for the search results learn more notice.
 */
export class SearchResultsLearnMoreNotice extends base.ViewModel {
    constructor(linkableText) {
        super();
        this.linkableText = linkableText;
    }
}
// endregion
//# sourceMappingURL=search.js.map