import * as models from "../base";
/**
 * @public
 * Returns the system image for the given search entity.
 */
export function searchEntitySystemImage(entity) {
    switch (entity) {
        case "developer":
            return "person.crop.square";
        case "story":
            return "appstore";
        case "watch":
            return "applewatch";
        case "arcade":
            return "joystickcontroller.fill";
        default:
            return undefined;
    }
}
/**
 * @public
 * Model representing selectable displayed token for Guided Search
 */
export class GuidedSearchToken extends models.ViewModel {
    constructor(value, isSelected, leadingIcon, displayName, clickAction) {
        super();
        this.value = value;
        this.isSelected = isSelected;
        this.leadingIcon = leadingIcon;
        this.displayName = displayName;
        this.clickAction = clickAction;
    }
}
/**
 * @public
 * Object storing mapping of:
 * Search Term + [Set of Guided Search Tokens] = Optimization Term.
 * I.e. how the search term and token swill be comined for final query term search results are searched for.
 */
export class GuidedSearchQuery extends models.Model {
    constructor(searchTerm, selectedTokens, optimizationTerm) {
        super();
        this.searchTerm = searchTerm;
        this.selectedTokens = selectedTokens;
        this.optimizationTerm = optimizationTerm;
    }
}
//# sourceMappingURL=guided-search.js.map