/**
 * Created by km on 2/13/17.
 */
import * as base from "./base";
import * as metrics from "./metrics/metrics";
import * as shelves from "./shelves";
/** @public */
export class Badge extends base.Model {
    constructor(type, key, content, style, heading, caption, longCaption, accessibilityTitle, accessibilityCaption, leadingValue = "infer") {
        super();
        this.type = type;
        this.key = key;
        this.content = content;
        this.heading = heading;
        this.caption = caption;
        this.longCaption = longCaption;
        this.leadingValue = leadingValue;
        this.accessibilityTitle = accessibilityTitle;
        this.accessibilityCaption = accessibilityCaption;
        this.style = style;
        this.isMonochrome = true;
    }
}
/** @public */
export class TextCard extends base.Model {
    constructor(headingType, title, subtitle) {
        super();
        this.titleStyle = headingType;
        this.title = title;
        this.subtitle = subtitle;
        this.isExpanded = false;
    }
}
/** @public */
export class ProductPageSection extends base.Model {
    constructor(type, shelfId) {
        super();
        this.type = type;
        this.shelfId = shelfId;
    }
}
/** @public */
export class ProductPageExpandedOfferDetails extends base.Model {
    constructor(title, subtitle) {
        super();
        this.title = title;
        this.subtitle = subtitle;
    }
}
/** @public */
export class ProductPage extends shelves.Lockup {
    constructor() {
        super();
        this.pageMetrics = new metrics.PageMetrics();
        this.pageRenderMetrics = {};
    }
}
//# sourceMappingURL=product.js.map