import { isNothing } from "@jet/environment/types/optional";
/**
 * All {@linkcode PreviewPlatform}, defined in their order of precidence
 */
export const allPreviewPlatforms = ["iphone", "ipad", "mac", "vision", "watch", "tv"];
/**
 * Determines if {@linkcode input} is a {@linkcode PreviewPlatform}
 */
export function isPreviewPlatform(input) {
    return allPreviewPlatforms.includes(input);
}
/**
 * Normalize some {@linkcode input} into a {@linkcode PreviewPlatform}, if possible
 */
export function normalizePreviewPlaform(input) {
    if (isNothing(input)) {
        return undefined;
    }
    const normalized = input.toLocaleLowerCase();
    if (isPreviewPlatform(normalized)) {
        return normalized;
    }
    return undefined;
}
//# sourceMappingURL=preview-platform.js.map