/**
 * Created by km on 2/13/17.
 */
import * as base from "./base";
import * as metrics from "./metrics/metrics";
/** @public */
export class GenericPage extends base.Model {
    constructor(shelfModels) {
        super();
        this.shelves = shelfModels;
        this.title = null;
        this.presentationOptions = [];
        this.isIncomplete = false;
        this.pageMetrics = new metrics.PageMetrics();
    }
}
/** @public */
export class InAppPurchaseInstallPage extends base.Model {
    constructor() {
        super();
        this.pageMetrics = new metrics.PageMetrics();
        this.pageRenderMetrics = {};
    }
}
/**
 * @public
 * Screen shown in search tab when search bar is focused but empty.
 */
export class SearchFocusPage extends GenericPage {
}
/**
 * @public
 * Initial screen shown in search tab when search bar is unfocused.
 */
export class SearchLandingPage extends GenericPage {
}
/** @public */
export class ArcadePage extends GenericPage {
}
/** @public */
export class ArcadeSeeAllGamesPage extends GenericPage {
    constructor(shelfModels) {
        super(shelfModels);
        this.pageSegments = [];
    }
}
//# sourceMappingURL=generic-page.js.map