import * as base from "./base";
import * as models from "./index";
import * as metrics from "./metrics/metrics";
/** @public */
export class AppEventFormattedDate extends models.Model {
    constructor(showLiveIndicator, displayFromDate, displayText, countdownToDate, countdownStringKey) {
        super();
        this.showLiveIndicator = showLiveIndicator;
        this.displayFromDate = displayFromDate;
        this.displayText = displayText;
        this.countdownToDate = countdownToDate;
        this.countdownStringKey = countdownStringKey;
    }
}
/** @public */
export var AppEventBadgeKind;
(function (AppEventBadgeKind) {
    AppEventBadgeKind["available"] = "available";
    AppEventBadgeKind["happening"] = "happening";
    AppEventBadgeKind["live"] = "live";
})(AppEventBadgeKind || (AppEventBadgeKind = {}));
export var AppPromotionType;
(function (AppPromotionType) {
    AppPromotionType["AppEvent"] = "appEvent";
    AppPromotionType["ContingentOffer"] = "contingentOffer";
    AppPromotionType["OfferItem"] = "offerItem";
})(AppPromotionType || (AppPromotionType = {}));
/** @public */
export class AppPromotion extends base.ViewModel {
    constructor(promotionType) {
        super();
        this.promotionType = promotionType;
    }
}
/** @public */
export class AppEvent extends AppPromotion {
    constructor(appEventId, moduleArtwork, moduleVideo, title, subtitle, detail, startDate, endDate, appEventBadgeKind, kind, requirements, lockup, hideLockupWhenNotInstalled, formattedDates, mediaOverlayStyle, includeBorderInDarkMode) {
        super(AppPromotionType.AppEvent);
        this.appEventId = appEventId;
        this.moduleArtwork = moduleArtwork;
        this.moduleVideo = moduleVideo;
        this.title = title;
        this.subtitle = subtitle;
        this.detail = detail;
        this.startDate = startDate;
        this.endDate = endDate;
        this.kind = kind;
        this.appEventBadgeKind = appEventBadgeKind;
        this.requirements = requirements;
        this.lockup = lockup;
        this.hideLockupWhenNotInstalled = hideLockupWhenNotInstalled;
        this.formattedDates = formattedDates;
        this.mediaOverlayStyle = mediaOverlayStyle;
        this.includeBorderInDarkMode = includeBorderInDarkMode;
        this.clickAction = null;
    }
}
/** @public */
export class AppEventDetailPage extends models.Model {
    constructor(appEvent, artwork, video, shareAction, mediaOverlayStyle, includeBorderInDarkMode) {
        super();
        this.appEvent = appEvent;
        this.artwork = artwork;
        this.video = video;
        this.shareAction = shareAction;
        this.mediaOverlayStyle = mediaOverlayStyle;
        this.includeBorderInDarkMode = includeBorderInDarkMode;
        this.pageMetrics = new metrics.PageMetrics();
        this.pageRenderMetrics = {};
    }
}
/**
 * Determines if a {@linkcode shelves.Shelf} is actually a {@linkcode AppEventDetailShelf}
 */
export function isAppEventDetailShelf(shelf) {
    return shelf.contentType === "appEventDetail";
}
/**
 * `Shelf` definition that wraps a single {@linkcode AppEventDetailPage}
 *
 * This is used to power the "web" client UI for an `app-event` detail page
 *
 * @public
 */
export class AppEventDetailShelf extends models.Shelf {
    constructor(detailPage) {
        super("appEventDetail", null, [detailPage]);
    }
}
/** @public */
export class AppEventNotificationConfig extends models.Model {
    constructor(appEventId, title, detail, artworkUrl, displayTime, scheduledAction, notAuthorizedAction, failureAction, destinationUrl, scheduleClickEvent, cancelScheduleClickEvent) {
        super();
        this.appEventId = appEventId;
        this.title = title;
        this.detail = detail;
        this.artworkUrl = artworkUrl;
        this.displayTime = displayTime;
        this.scheduledAction = scheduledAction;
        this.notAuthorizedAction = notAuthorizedAction;
        this.failureAction = failureAction;
        this.destinationUrl = destinationUrl;
        this.scheduleClickEvent = scheduleClickEvent;
        this.cancelScheduleClickEvent = cancelScheduleClickEvent;
    }
}
/** @public */
export class ContingentOffer extends AppPromotion {
    constructor(backgroundArtwork, mediaOverlayStyle, isStreamlinedBuy, learnMoreTitle, titleFormatted, subtitle, description, label, badge, additionalInfo, trunkAppIcon, offerLockup) {
        super(AppPromotionType.ContingentOffer);
        this.backgroundArtwork = backgroundArtwork;
        this.isStreamlinedBuy = isStreamlinedBuy;
        this.mediaOverlayStyle = mediaOverlayStyle;
        this.titleFormatted = titleFormatted;
        this.subtitle = subtitle;
        this.additionalInfo = additionalInfo;
        this.description = description;
        this.label = label;
        this.badge = badge;
        this.offerLockup = offerLockup;
        this.trunkAppIcon = trunkAppIcon;
        this.learnMoreTitle = learnMoreTitle;
        this.clickAction = null;
    }
}
/** @public */
export class AppPromotionDetailPage extends base.ViewModel {
    constructor(promotionType) {
        super();
        this.promotionType = promotionType;
    }
}
/** @public */
export class ContingentOfferDetailPage extends AppPromotionDetailPage {
    constructor(contingentOffer, artwork, mediaOverlayStyle) {
        super(AppPromotionType.ContingentOffer);
        this.contingentOffer = contingentOffer;
        this.artwork = artwork;
        this.mediaOverlayStyle = mediaOverlayStyle;
        this.pageMetrics = new metrics.PageMetrics();
        this.pageRenderMetrics = {};
        this.learnMoreActionMetrics = new metrics.ActionMetrics();
        this.backButtonActionMetrics = new metrics.ActionMetrics();
        this.closeButtonActionMetrics = new metrics.ActionMetrics();
    }
}
/** @public
 *
 *
 */
export class OfferItem extends AppPromotion {
    constructor(moduleArtwork, moduleVideo, mediaOverlayStyle, isStreamlinedBuy, titleFormatted, expiryDateFormatted, subtitle, description, badge, endDate, iapArtwork, offerLockup) {
        super(AppPromotionType.OfferItem);
        this.moduleArtwork = moduleArtwork;
        this.moduleVideo = moduleVideo;
        this.isStreamlinedBuy = isStreamlinedBuy;
        this.mediaOverlayStyle = mediaOverlayStyle;
        this.titleFormatted = titleFormatted;
        this.description = description;
        this.badge = badge;
        this.offerLockup = offerLockup;
        this.subtitle = subtitle;
        this.endDate = endDate;
        this.expiryDateFormatted = expiryDateFormatted;
        this.iapArtwork = iapArtwork;
        this.clickAction = null;
    }
}
/** @public */
export class OfferItemDetailPage extends AppPromotionDetailPage {
    constructor(offerItem, artwork, video, mediaOverlayStyle, includeBorderInDarkMode, learnMoreTitle, additionalInfo) {
        super(AppPromotionType.OfferItem);
        this.offerItem = offerItem;
        this.artwork = artwork;
        this.learnMoreTitle = learnMoreTitle;
        this.video = video;
        this.mediaOverlayStyle = mediaOverlayStyle;
        this.pageMetrics = new metrics.PageMetrics();
        this.additionalInfo = additionalInfo;
        this.pageRenderMetrics = {};
        this.learnMoreActionMetrics = new metrics.ActionMetrics();
        this.backButtonActionMetrics = new metrics.ActionMetrics();
        this.closeButtonActionMetrics = new metrics.ActionMetrics();
    }
}
//# sourceMappingURL=app-promotions.js.map