import * as base from "./base";
/**
 * The `Annotation` model describes a category of information about an app,
 * such as supported languages, app size, content ratings, in-app-purchase
 * info, etc.
 *
 * `Annotations` always have a title and summary, and most also have an `items`
 * array of `AnnotationItem`s with more fine-grained details.
 *
 * @public
 */
export class Annotation extends base.Model {
    constructor(title, items, summary, linkAction) {
        super();
        this.title = title;
        this.summary = summary;
        this.items = items;
        this.items_V3 = [];
        this.shouldAlwaysPresentExpanded = false;
        this.linkAction = linkAction;
    }
}
/**
 * A single item used to show more details in an `Annotation`. This could be an
 * In-App Purchase, supported language list, a link to an editorial item, etc.
 * @public
 */
export class AnnotationItem extends base.Model {
    constructor(text, options = {}) {
        super();
        this.text = text;
        this.heading = options.heading;
        this.headingArtworks = options.headingArtworks;
        this.listText = options.listText;
        this.textPairs = options.textPairs;
    }
}
/**
 * Used on tvOS to visually group related `Annotation` objects into a column.
 * @public
 */
export class AnnotationGroup extends base.Model {
    constructor(title, annotations, forceExpanded) {
        super();
        this.title = title;
        this.annotations = annotations;
        this.forceExpanded = forceExpanded;
    }
}
//# sourceMappingURL=annotation.js.map