import * as models from "./index";
/**
 * @public
 * A model that represents an accessibility feature of a product.
 */
export class AccessibilityFeature extends models.Model {
    constructor(title, description, artwork) {
        super();
        this.title = title;
        this.description = description;
        this.artwork = artwork;
    }
}
/**
 * @public
 * A model that represents a set of accessibility features of a product.
 */
export class AccessibilityFeatures extends models.ViewModel {
    constructor(title, artwork, features) {
        super();
        this.title = title;
        this.artwork = artwork;
        this.features = features;
    }
}
/**
 * @public
 * A model that represents a paragraph of linkable text, displayed in the accessibility section.
 */
export class AccessibilityParagraph extends models.ViewModel {
    constructor(text, actions) {
        super();
        this.text = text;
        this.actions = actions;
    }
}
//# sourceMappingURL=accessibility.js.map