import { normalizePreviewPlaform } from "../models/preview-platform";
import { normalizeAdamID } from "../util";
const ROOM_PAGE_INTENT_KIND = "RoomPageIntent";
export function makeRoomPageIntent(opts) {
    const { platform, id, ...rest } = opts;
    return {
        ...rest,
        platform: normalizePreviewPlaform(platform),
        id: normalizeAdamID(id),
        $kind: ROOM_PAGE_INTENT_KIND,
    };
}
export function isRoomPageIntent(intent) {
    return (intent === null || intent === void 0 ? void 0 : intent.$kind) === ROOM_PAGE_INTENT_KIND;
}
//# sourceMappingURL=room-page-intent.js.map