import { normalizeAdamID } from "../util";
import { normalizePreviewPlaform } from "../models/preview-platform";
export function makeProductPageIntent(opts) {
    const { id, platform, ppid, lic, ...rest } = opts;
    return {
        ...rest,
        $kind: "ProductPageIntent",
        id: normalizeAdamID(id),
        platform: normalizePreviewPlaform(platform),
        ppid,
        lic,
    };
}
export function isProductPageIntent(intent) {
    return (intent === null || intent === void 0 ? void 0 : intent.$kind) === "ProductPageIntent";
}
//# sourceMappingURL=product-page-intent.js.map