import { normalizePreviewPlaform } from "../../models/preview-platform";
export function isEditorialPageIntent(intent) {
    return (intent === null || intent === void 0 ? void 0 : intent.$kind) === "EditorialPageIntent";
}
export function isEditorialPageIntentByID(intent) {
    return isEditorialPageIntent(intent) && "id" in intent;
}
export function isEditorialPageIntentByName(intent) {
    return isEditorialPageIntent(intent) && "name" in intent;
}
/**
 * Creates an {@link EditorialPageIntent} that fetches an Editorial Page by "name"
 *
 * @param options the properties of the created {@link EditorialPageIntentByName}
 */
export function makeEditorialPageIntentByName(options) {
    const { platform, ...rest } = options;
    return {
        ...rest,
        $kind: "EditorialPageIntent",
        platform: normalizePreviewPlaform(platform),
    };
}
/**
 * Creates an {@link EditorialPageIntent} that fetches an Editorial Page by "id"
 *
 * @param options the properties of the created {@linkcode EditorialPageIntentById}
 */
export function makeEditorialPageIntentByID(options) {
    const { platform, ...rest } = options;
    return {
        $kind: "EditorialPageIntent",
        platform: normalizePreviewPlaform(platform),
        ...rest,
    };
}
//# sourceMappingURL=editorial-page-intent.js.map