import { normalizeAdamID } from "../util";
const DEVELOPER_PAGE_INTENT_KIND = "DeveloperPageIntent";
/**
 * Determines if {@linkcode intent} is a {@linkcode DeveloperPageIntent}
 */
export function isDeveloperPageIntent(intent) {
    return intent.$kind === DEVELOPER_PAGE_INTENT_KIND;
}
/**
 * Creates a {@linkcode DeveloperPageIntent}
 */
export function makeDeveloperPageIntent({ id, ...rest }) {
    return {
        ...rest,
        id: normalizeAdamID(id),
        $kind: DEVELOPER_PAGE_INTENT_KIND,
    };
}
//# sourceMappingURL=developer-page-intent.js.map